%% Version 2019-04-01 11:44:31
%%
%% This is file `cmsart.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% cmsart.dtx 
%% 
%% This is the style file for the Canadian Mathematical Bulletin
%% and Canadian Journal of Mathematics.
%% 
%% \iffalse
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{cmsart}
              [2018/11/01 2.0
 Canadian Mathematical Society document class]
%% \fi
\newif\if@cms@editorial
\newif\if@cms@PRF
\DeclareOption{PRF} { \@cms@PRFtrue }
\newif\if@cms@FVW
\def\@cms@FVWcode {\@cms@FVWtrue\@cms@editorialtrue}
\DeclareOption{FVW}{\@cms@FVWcode}
\DeclareOption{OLF}{\@cms@FVWcode}
\def\@cms@ISScode
    {\setlength\overfullrule{0pt}\@cms@FVWfalse\@cms@editorialtrue}
\DeclareOption{ISS}{\@cms@ISScode}
\DeclareOption{PRT}{\@cms@ISScode}
\DeclareOption{NCL}
    {\let\NOCOLORLINKS=1}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{amsart}}
\PassOptionsToPackage{leqno,tbtags}{amsmath}
\ProcessOptions
\LoadClass[twoside,onecolumn,notitlepage,letterpaper]{amsart}
\RequirePackage[francais,english,shorthands=off]{babel}
\RequirePackage{iflang}
\RequirePackage{graphicx}
\RequirePackage{ifmtarg}
\RequirePackage{xparse}
\RequirePackage{amsmath}
\RequirePackage{amsthm}
\RequirePackage{array}

\RequirePackage[shortlabels,inline]{enumitem}

\RequirePackage{fancyhdr}
\RequirePackage[colorlinks,allcolors=blue,bookmarks=false]{hyperref}
\RequirePackage{upref}
\RequirePackage{everyshi}
\RequirePackage[noindentafter]{titlesec}
\RequirePackage{etoolbox}
\RequirePackage[noadjust]{cite}
\RequirePackage{mathtools}
\mathtoolsset{showonlyrefs,showmanualtags}

\ifx\NOCOLORLINKS\undefined
\hypersetup{colorlinks=true}
\else
\message{NO--COLOR--LINKS}
\hypersetup{colorlinks=false}
\fi
\def\@typesizes{%
\or{\@vipt}{\@vipt}% Tiny = 6/6
\or{\@vipt}{\@viipt}% tiny = 6/7
\or{\@viipt}{\@viiipt}% SMALL = 7/8
\or{\@viiipt}{\@ixpt}% Small = 8/9
\or{\@ixpt}{\@xipt}% small = 9/11
\or{\@xpt}{\@xiipt}% normalsize = 10/12
\or{\@xivpt}{18}% large = 14/18
\or{\@viipt}{\@xxpt}% Large = 17/22
\or{\@xxpt}{\@xvpt}% LARGE = 20/25
\or{\@xvpt}{\@xxxpt}% huge  = 25/30
\or{\@xvpt}{\@xxxpt}% Huge  = 25/30
}
\setlength\parindent{12\p@}
\renewenvironment{quote}
    {\list{} {\leftmargin=12pt\rightmargin=\leftmargin}\item[]}
    {\endlist}
    \RequirePackage[
        paperwidth=   160mm,  %6.3in,  ?
        paperheight=  247mm,  %9.72in, ?
        textwidth=    118mm,
        textheight=   192mm,
        hcentering,
        vcentering,
        heightrounded,
        \if@cms@PRF
            driver=none,
        \else
            driver=pdftex,
        \fi
    ]{geometry}
    \if@cms@PRF
        \RequirePackage[cam,noinfo,letter,center]{crop}
    \fi
\def\fnum@figure{
   \normalfont\fontsize{9pt}{11pt}\itshape\mdseries\selectfont
   \figurename\nobreakspace\thefigure\upshape}

\long\def\@makecaption#1#2{%
  \setbox0=\hbox{#2}
  \ifdim\wd0=0pt\def\captionpunct{}\else\def\captionpunct{:}\fi
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1\captionpunct{} #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1\captionpunct{} #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
\setlength\abovecaptionskip{14\p@}
\setlength\@fpsep{10\p@ \@plus 2fil}  %% was: 8pt plus2fil ?

\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}
\pagestyle{fancy}
\fancyhf{}
\fancyhead[LO]{\let\\=\space\itshape\@cms@runningtitle}
\fancyhead[RE]{\upshape\@cms@runningauthor}
\fancyhead[RO,LE]{\thepage}
\fancypagestyle{firstpage}{%
  \fancyhf{}%
  \if@cms@editorial
    \fancyhead[L]{\@cms@serieslogo}%
    \if@cms@PRF\else
        \fancyhead[R]{\@setCMSlogo}%
    \fi
  \fi
}
\setlength{\headheight}{16pt}
\setlength{\headsep}{8pt}
\long\def\@cms@serieslogo{%
  \vbox to\z@{%
      \hsize=0.7\textwidth
      \@parboxrestore \footnotesize \noindent
        \if@cms@FVW\@cms@journalname\else\@cms@shortjournalname\fi{}
        \if@cms@FVW\else %% Skip for online version.
            Vol.\ \textbf{\@cms@volumenumber} (\@cms@issuenumber),
                \@cms@publicationyear\
            \ifnum\thepage=\the@finalpage p.\ \thepage
            \else pp.\ \thepage--\the@finalpage
            \fi
        \fi
    \ifx\@cms@articledoi\@empty\else
        \\\doitag\doiprefix/\@cms@articledoi \fi
    \\ \smash{\raise0.8pt\hbox{\copyright}}\kern1pt
    \@cms@copyrightname{} \@cms@copyrightyear%
    \par\vss
  }
}
\def\@setCMSlogo{%  Some positioning hacks.
    \begin{picture}(0,0)
        \put(-47,-12) { \includegraphics[height=8.5mm]{CMS-hlogo} }
    \end{picture}%
    }

\newcommand\@cms@runninghead@setup{
\andify\shortauthors
\@xp\gdef\@xp\@cms@runningauthor\@xp{\shortauthors}
\let\@cms@runningtitle=\shorttitle
\setbox0=\hbox{\small\@cms@runningauthor}
\ifdim\wd0>0.9\textwidth
\ClassError{cmsart}{Running author is too long.
    ^^J Please shorten it using \@nx\setrhead{}.}
\fi
\setbox0=\hbox{\small\itshape\@cms@runningtitle}
\ifdim\wd0>0.9\textwidth
\ClassError{cmsart}{Running title is too long.
    ^^J Please shorten it using \@nx\title[Short title]{Long title}.}
\fi
}
\def\@cms@runningauthor{}
\def\@cms@runningtitle{}
\let\@orig@maketitle=\maketitle
\renewcommand\maketitle{
\@cms@runninghead@setup
\@orig@maketitle
}
\def\@@and{\biling{et}{and}}
\renewcommand{\andify}{%
  \nxandlist{\unskip, }{\unskip{} \@@and~}{\unskip\biling{}{,} \@@and~}}
\let\dedication=\dedicatory
\dedication{}
\newcounter{@firstpage}
\newcommand*\startpage[1]{\setcounter{page}{#1}
    \setcounter{@firstpage}{#1}}
\def\@cms@CMBtxt{CMB}
\def\@cms@CJMtxt{CJM}
\def\@cms@shortjournalname{CMB or CJM?}
\def\@cms@journalname{CMB or CJM?}
\newcommand{\journal}[1]{
  \def\tmp{#1}
  \ifx\tmp\@cms@CMBtxt
    \def\@cms@shortjournalname{Canad.~Math.~Bull.}
    \def\@cms@journalname{%
        \biling {Bulletin Canadien de Math\'ematiques}
                {Canadian Mathematical Bulletin}}
  \else \ifx\tmp\@cms@CJMtxt
    \def\@cms@shortjournalname{Canad.~J.~Math.}
    \def\@cms@journalname{%
        \biling {Journal Canadien de Math\'ematiques}
                {Canadian Journal of Mathematics}}
  \else \ClassError{cmsart}{Invalid journal name #1; must be CJM or CMB}
  \fi \fi
}
\newcommand*\volumenumber[1]{\def\@cms@volumenumber{#1}}
\newcommand*\issuenumber[1]{\def\@cms@issuenumber{#1}}
\newcommand*\publicationyear[1]{\def\@cms@publicationyear{#1}}
\renewcommand*\copyrightyear[1]{\def\@cms@copyrightyear{#1}}
\newcounter{@finalpage}
\newcounter{@pagecount}
\newcommand*\pagecount[1]{%
    \setcounter{@pagecount}{#1}%
   \setcounter{@finalpage}{\thepage}%
   \addtocounter{@finalpage}{#1}%
   \addtocounter{@finalpage}{-1}%
   }
\let\numberofpages=\pagecount
\startpage{1}
\pagecount{0}
\volumenumber{00}
\issuenumber{0}
\publicationyear{0000}
\copyrightyear{0000}

\newcommand*\copyrightname[1]{\def\@cms@copyrightname{#1}}
\copyrightname{\biling{Soci\'et\'e math\'ematique du Canada}
         {Canadian Mathematical Society}}

\def\doiprefix{10.4153}
\def\doitag{http://dx.doi.org/}
\newcommand\articleDOI[1]{\def\@cms@articledoi{#1}}
\def\@cms@articledoi{XXX-0000-000-x}
\let\DOI=\articleDOI
\def\@cms@onlinedate{}
\newcommand\onlinedate[1]
{\def\@ARGS{#1}
\ifx\@ARGS\@empty
\def\@cms@onlinedate{}\else
\def\@cms@onlinedate{ \@cms@prtdate(#1)}
\fi
\copyrightyear{\@cms@year}}

\newcommand*\received[1]{\def\@cms@receiveddate{\@cms@prtdate(#1)}}
\newcommand*\revised[1]{\def\tmp{#1}%
    \ifx\tmp\@empty\let\@cms@reviseddate\relax%
    \else%
    \def\@cms@reviseddate{\@cms@prtdate(#1)}\fi}
   \received{0000-00-00}
   \revised{}
\let\accepted\@gobble
\newcommand*\amsclassification[2]
    {\def\@subjclass{\textbf{#1}\@ifmtarg{#2}{}{, #2}}}


\def\@cms@CUPid{\jobname}  % fallback
\newcommand*\CUPid[1]{\def\@cms@CUPid{#1}}
\def\@cms@copyeditor{}
\newcommand*\copyeditor[1]{\def\@cms@copyeditor{\ (#1)}}

\renewenvironment{abstract}{%
  \ifx\maketitle\relax
    \ClassError{\@classname}{Abstract should precede
      \protect\maketitle}%
  \fi
  \global\setbox\abstractbox=\vtop \bgroup
    \normalfont\Small
\baselineskip10pt
    \list{}{\labelwidth\z@
      \leftmargin\z@\rightmargin12pt
      \listparindent\normalparindent \itemindent\z@
      \parsep\z@ \@plus\p@
      \let\fullwidthdisplay\relax
    }%
    \item[\hskip\labelsep\itshape\abstractname.]%
}{%
  \endlist\egroup
  \ifx\@setabstract\relax \@setabstracta \fi
}

\newcommand{\newabstract}{%
  \par\bigskip
  \item[\hskip\labelsep\itshape\abstractname.]%
}

\def\@maketitle{%
  \normalfont\normalsize
  \@adminfootnotes
  \@mkboth{\@nx\shortauthors}{\@nx\shorttitle}%
  \global\topskip42\p@\relax % 5.5pc
  \@settitle
  \ifx\@empty\@dedicatory
  \else
    \baselineskip24\p@
    \vtop{\raggedright{\normalsize\itshape\@dedicatory\@@par}%
      \global\dimen@i\prevdepth}\prevdepth\dimen@i
  \fi
  \ifx\@empty\authors \else \@setauthors \fi
  \@setabstract
  \normalsize
} % end \@maketitle

\def\@settitle{
    {\normalfont\fontsize{17.28pt}{20pt}\sffamily\mdseries\selectfont
       \raggedright
       {\@title}\par }%
}

\def\@setsubjclass{%
  {\subjclassname:}\enspace \@subjclass\@addpunct.}
\def\@setkeywords{%
  {\keywordsname:}\enspace \@keywords\@addpunct.}

\def\@adminfootnotes{%
  \let\@makefnmark\relax  \let\@thefnmark\relax
\if@cms@editorial
   \ifx\@cms@reviseddate\relax
     \@footnotetext{%
         \biling{Re\c{c}u par la r\'edaction le}
                {Received by the editors}
         \@cms@receiveddate. }
   \else
      \@footnotetext{%
         \biling{Re\c{c}u par la r\'edaction le}
                {Received by the editors}
         \@cms@receiveddate;
         \biling{revu le}{revised}
         \@cms@reviseddate.}
   \fi
\@footnotetext{
        \biling{Publi\'e en ligne}{Published online}%
        \@cms@onlinedate.}
\fi
  \ifx\@empty\thankses\else
    \@footnotetext{\def\par{\let\par\@par}\@setthanks}\fi
  \ifx\@empty\@subjclass\else \@footnotetext{\@setsubjclass}\fi
  \ifx\@empty\@keywords\else \@footnotetext{\@setkeywords}\fi
}
\def\author@andify{%
  \nxandlist {\unskip ,\penalty-1 \space\ignorespaces}%
    {\unskip {} \@@and~}%
    {\unskip \biling{}{,}\penalty-2 \space \@@and~}%
}

\def\@setauthors{%
  \begingroup
  \def\thanks{\protect\thanks@warning}%
  \trivlist
  \raggedright\footnotesize \@topsep24\p@\relax
  \advance\@topsep by -\baselineskip
  \item\relax
  \author@andify\authors
      \normalfont\fontsize{12pt}{14pt}\rmfamily\mdseries\selectfont
  \authors
  \def\\{\protect\linebreak}%
  \ifx\@empty\contribs
  \else
    ,\penalty-3 \space \@setcontribs
    \@closetoccontribs
  \fi
  \endtrivlist
  \endgroup
}
\def\@setcontribs{%
  \@xcontribs
  \xcontribs
}
\newcommand\setrhead[1]{\gdef\shortauthors{#1}}
\newcommand\setlhead[1]{\gdef\shorttitle{#1}}

\def\@cms@prtdate(#1-#2-#3){\gdef\@cms@year{#1}
        {\year#1\month#2\day#3\today}}

\renewcommand{\abstractname}
    {\biling{R\'esum\'e}{Abstract}}
\renewcommand{\keywordsname}
    {\biling{Mots cl\'es}{Keywords}}
\renewcommand{\subjclassname}
    {\biling{Classification (AMS) par sujet}
             {AMS subject classification}}

\def\emailaddrname{{\itshape \biling{courriel}{Email}}}
\def\urladdrname{{\itshape URL}}
\newcommand\addressmacro[1]{\g@addto@macro\addresses{#1}}

\newcommand\addressplus[1][and]
    {\par\smallskip\textup{#1}\par\smallskip}

\def\@setaddresses{\par
  \nobreak \begingroup
    \parindent=0pt
    \footnotesize
  \def\\{\unskip, \ignorespaces}%
  \interlinepenalty\@M
  \def\address##1##2{%
    \def\@cms@emailhead{\emailaddrname\biling{~}{\,}:}
    \begingroup
    \par\addvspace\medskipamount\indent
    \@ifnotempty{##1}{\upshape(\ignorespaces##1\unskip) }%
    {\itshape\ignorespaces##2}\par\endgroup}%
  \def\email##1##2{\begingroup
      \@ifnotempty{##2}{\nobreak\indent\@cms@emailhead\space
      \mbox{\@ifnotempty{##1}{\ignorespaces(##1)\unskip}\space
        \href{mailto:##2}{\nolinkurl{##2}}}}\endgroup
        \let\@cms@emailhead\space
    }%
  \def\urladdr##1##2{\begingroup
    \def~{\char`\~}%
    \@ifnotempty{##2}{\par\nobreak\indent\urladdrname
      \@ifnotempty{##1}{, \ignorespaces##1\unskip}\/:\space
      \url{##2}\par
    }\endgroup}%
  \addresses
  \par %% to fix baselineskip in last email
  \endgroup
}


\AtEndDocument{\clearpage\addtocounter{page}{-1}
   \ifnum\value{@finalpage}=\value{page}
   \message{^^JPagecount OK^^J}
   \else
   \ClassWarning{\@classname}{^^J
*********
^^J
                PAGECOUNT ERROR (computed:\the@finalpage
                \space actual:\thepage)
^^J
                set \string\pagecount{}
                to the correct value.
^^J
*********^^J}
   \fi
   }


\newcounter{subsection@nt}[section]
\newcounter{subsubsection@nt}[subsection]
\providecommand\toclevel@subsection@nt{0}
\providecommand\toclevel@subsubsection@nt{0}
\titleclass{\subsection@nt}{straight}[\section]
\renewcommand{\thesubsection@nt}
    {\thesection.\arabic{subsection@nt}}

\titleclass{\subsubsection@nt}{straight}[\subsection@nt]
\renewcommand{\thesubsubsection@nt}
    {\thesubsection.\arabic{subsubsection@nt}}

\setcounter{secnumdepth}{5}
\pretocmd{\subsection@nt}{\stepcounter{subsection}}{}{}
\pretocmd{\subsection}{\stepcounter{subsection@nt}}{}{}

\pretocmd{\subsubsection@nt}{\stepcounter{subsubsection}}{}{}
\pretocmd{\subsubsection}{\stepcounter{subsubsection@nt}}{}{}
\newcommand\@secnumbox[1]{\llap{\makebox[2.5pc][r]{#1\hspace{9pt}}}}
\newcommand\@subsubsecnumbox[1]{#1\hspace{6pt}}  %% in-line

\titleformat{\section}
{\normalfont\fontsize{12pt}{14pt}\sffamily\bfseries\selectfont}
{\@secnumbox{\thesection}}
{0em}{\bfseries}

\titleformat{\subsection}
{\normalfont\fontsize{10pt}{12pt}\sffamily\bfseries\selectfont}
{\@secnumbox{\thesubsection}}
{0em}{\bfseries}

\titleformat{\subsection@nt}[runin]
{\normalfont\fontsize{10pt}{12pt}\sffamily\bfseries\selectfont}
{\@secnumbox{\thesubsection@nt}}
{0em}{\bfseries}

\titleformat{\subsubsection}
{\normalfont\fontsize{10pt}{12pt}\sffamily\bfseries\selectfont}
{\@subsubsecnumbox{\thesubsubsection}}
{0em}{\bfseries}

\titleformat{\subsubsection@nt}[runin]
{\normalfont\fontsize{10pt}{12pt}\sffamily\bfseries\selectfont}
{\@subsubsecnumbox{\thesubsubsection@nt}}
{0em}{\bfseries}

\titleformat{\paragraph}[runin]
{\normalfont\fontsize{10pt}{12pt}\sffamily\bfseries\selectfont}
{\@secnumbox{\thesubsection}}
{0em}{\bfseries}

\titleformat{\subparagraph}[runin]
{\normalfont\fontsize{10pt}{12pt}\sffamily\bfseries\selectfont}
{\@secnumbox{\thesubsection}}
{0em}{\normalfont}
\titlespacing*{\chapter}{0pt}{0pt}{20pt}
\titlespacing*{\section}{0pt}{10pt}{ 9pt}
\titlespacing*{\subsection}{0pt}{10pt}{9pt}
\titlespacing*{\subsection@nt}{0pt}{12pt}{0pt}
\titlespacing*{\subsubsection}{0pt}{12pt}{9pt}
\titlespacing*{\subsubsection@nt}{0pt}{3.25ex plus 1ex minus .2ex}{0em}
\titlespacing*{\paragraph}{0pt}{6pt}{1em}
\titlespacing*{\subparagraph}{0pt}{6pt}{1em}
\let\@origsubsection=\subsection
\RenewDocumentCommand \subsection { s m } {
    \IfBooleanTF{#1}
        {\@origsubsection*{#2}}
        {\@ifmtarg{#2}
            {\subsection@nt{}}
            {\@origsubsection{#2}}
        }
    }
\let\@origsubsubsection=\subsubsection
\RenewDocumentCommand \subsubsection { s m } {
    \IfBooleanTF{#1}
        {\@origsubsubsection*{#2}}
        {\@ifmtarg{#2}
            {\subsubsection@nt{}}
            {\@origsubsubsection{#2}}
        }
    }
\let\compactenum=\enumerate
\let\endcompactenum=\endenumerate
\let\compactitem=\itemize
\let\endcompactitem=\enditemize

\newlist{asparaenum}{enumerate}{3}
\setlist[asparaenum]{wide, label=(\roman*}
\newlist{asparaitem}{itemize}{1}
\setlist[asparaitem]{wide, label=\textbullet}
\setlist[enumerate]{topsep=0pt,partopsep=0pt,itemsep=0pt,parsep=0pt}
\setlist[itemize]{topsep=0pt,partopsep=0pt,itemsep=0pt,parsep=0pt}


\setenumerate{ leftmargin=22pt, }
\setitemize  { leftmargin=22pt, }
\setlist{font=\textup}

\newcommand\smallbullet{\raisebox{.3ex}{\tiny$\bullet$}}
\setitemize[1]{label=\smallbullet}
\setcounter{tocdepth}{2}
\renewcommand\refname{\biling{R\'ef\'erences}{References}}
\renewenvironment{thebibliography}[1]{%
  \@bibtitlestyle
\vskip2pt  %% Added
  \normalfont\bibliofont\labelsep .5em\relax
  \renewcommand\theenumiv{\arabic{enumiv}}\let\p@enumiv\@empty
  \list {\@biblabel{\theenumiv}}
        {\settowidth\labelwidth{\@biblabel{#1}}%
         \leftmargin\labelwidth
         \advance\leftmargin\labelsep
         \usecounter{enumiv}}%
  \sloppy \clubpenalty\@M \widowpenalty\clubpenalty
  \sfcode`\.=\@m
\raggedright  %% Added
}{%
  \def\@noitemerr{\@latex@warning{Empty `thebibliography'
environment}}%
  \endlist
}

\newcommand\repeatauthor[1][0]{\leavevmode\hbox to 3em{\hrulefill}}
\let\sameauthor=\repeatauthor

\newcommand\doi[1]{\hspace{6pt}\url{http://dx.doi.org/#1}}
%% To print a url with hyperlink:
\newcommand\hurl[1]{\href{#1}{\nolinkurl{#1}}}
\newcommand\arxiv[1]{\href{http://arxiv.org/abs/#1}
                          {\nolinkurl{arxiv:#1}}
}
\def\UrlFont{\sffamily}

\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width120pt
  \kern2.6\p@}
\newcommand{\english}{\selectlanguage{english}}
\newcommand{\french}{\selectlanguage{francais}}
\newcommand{\biling}[2]{\IfLanguageName{francais}{#1}
    {\IfLanguageName{francais}{#1}{#2}}}


\newtheoremstyle{plain}
{10pt plus 1pt}{10pt plus 2pt}
    {\itshape}{0pt}{\bfseries\itshape}{}
    {10pt}{\thmname{#1} \thmnumber{ \itshape#2}
            \thmnote{ \textup{\textmd{(#3)}}}}

\theoremstyle{plain}  %% make it the default

\newtheoremstyle{definition}
    {\topskip}{\topskip}
    {\upshape%
    }{0pt}{\bfseries\itshape}{}
    {10pt}{\thmname{#1} \thmnumber{ \itshape#2}
            \thmnote{ \textup{\textmd{(#3)}}}}

\renewenvironment{proof}[1][\proofname]{\par
  \pushQED{\qed}%
  \normalfont \topsep6\p@\@plus6\p@\relax
  \trivlist
  \item[\hskip\labelsep
        \bfseries #1 \ ]\ignorespaces
}{%
  \popQED\endtrivlist\@endpefalse
}
\renewcommand{\proofname}{\biling{Preuve}{Proof}}
\renewcommand\qedsymbol
    {\vrule \@height6pt \@width 6pt \@depth 0pt}

\if@cms@PRF
\@cms@editorialtrue
\AtBeginDocument{%
    \overfullrule=5pt
    \@tempcnta\time\@tempcntb\@tempcnta
    \divide\@tempcntb by 60\multiply\@tempcntb by 60
    \advance\@tempcnta-\@tempcntb\divide\@tempcntb by 60
    \edef\@cms@time{\today\  \ifnum\@tempcntb<10 0\fi
        \number\@tempcntb:\ifnum\@tempcnta<10 0\fi\number\@tempcnta }
  }
\newcounter{@sheetnumber}
\EveryShipout{\stepcounter{@sheetnumber}}
\font\@cms@pffont=cmss8
\def\@cms@banner{\@cms@pffont DRAFT:
    \@cms@shortjournalname\quad \@cms@time
    \quad \@cms@CUPid \@cms@copyeditor
    \quad pp.~\the@firstpage--\the@finalpage
    \quad Page \thepage,
    Sheet \the@sheetnumber\ of \the@pagecount}

\newcount\g@count \g@count=0
\newsavebox\@cms@vruler
\sbox\@cms@vruler{%
    \setlength\unitlength{12pt}
    \begin{picture}(0,0)(2,4.6) \@cms@pffont
        \loop \ifnum\g@count<48
            \advance \g@count by 1
            \put(1.5,-\g@count){\llap{{\number\g@count}
                \rule{1em}{.4pt}}}
        \repeat
\end{picture}%
}
\newcommand\CROP@user@a{
    \vbox to 0pt{%
        \rlap{\usebox\@cms@vruler}\vss}%
        \vbox to \z@{\vss\rlap{\qquad\@cms@banner}\vspace{9pt}}%
    }
\fi

\newcommand{\tabshift}[1]{\kern#1&\kern-#1}
\let\ktab=\tabshift

\newcommand{\dstrut}[1][9pt]{\vrule width0pt height 0pt depth#1\relax}
\newcommand{\ustrut}[1][15pt]{\vrule width0pt depth 0pt height#1\relax}

\newcommand\thispar[1]{\bgroup\def\par{\endgraf\egroup}#1}
\newcommand{\centermark}[2]{\mbox{$#2 #1 #2$}}
\newcommand\wdot{\centermark{\cdot}{\mkern3mu}}
\newcommand\wcol{\centermark{:}{\mkern2mu}}
\newcommand\semi{\mathrel{;}}
\let\nbd=\nobreakdash
\let\from=\colon

\newcommand{\tsl}[1]{\mathop{\textstyle #1}\limits}

\newcommand\lfrac[2]{{#1}/{#2}}         % x/y
\newcommand\nlfrac[2]{({#1})/{#2}}      % (x+z)/yyy
\newcommand\dlfrac[2]{{#1}/({#2})}      % xxx/(y+z)
\newcommand\ndlfrac[2]{({#1})/({#2})}   % (x+z)/(y+z)
\let\tlfrac=\nlfrac
\let\blfrac=\dlfrac
\let\tblfrac=\ndlfrac

\newcommand\WARN[1]{\message{%
   ============================^^J
   ===========WARNING==========^^J
#1
^^J===========WARNING==========/^^J
   ============================/ ^^J
}}

\newcommand{\llb}{[\mkern-3mu[}
\newcommand{\rrb}{]\mkern-3mu]}
\newcommand{\llp}{(\mkern-3mu(}
\newcommand{\rrp}{)\mkern-3mu)}

\def\translate #1\by#2 #3 {%
   \vbox to 0pt{\kern -#3 \rlap{\kern #2 #1}\vss}%
   \nointerlineskip}


\newif\iftop@           \newif\ifbot@
\def\topsmash{\top@true\bot@false\smash@}
\def\botsmash{\top@false\bot@true\smash@}
\def\smash{\top@true\bot@true\smash@}
\def\smash@{\relax\ifmmode\def\next{\mathpalette\mathsm@sh}%
        \else\let\next\makesm@sh\fi \next }
\def\finsm@sh{\iftop@\ht\z@\z@\fi\ifbot@\dp\z@\z@\fi\box\z@}

\long\def\ulap#1{\vbox to \z@{\vss#1}}
\long\def\dlap#1{\vbox to \z@{#1\vss}}

\def\xlap#1{\hbox to \z@{\hss#1\hss}}
\long\def\ylap#1{\vbox to \z@{\vss#1\vss}}
\long\def\zlap#1{\ylap{\xlap{#1}}}

\def\basezero{\baselineskip\z@skip \lineskip\z@skip}

\def\nullhrule{\hrule height\z@ depth\z@ width\z@ }
\def\nullvrule{\vrule height\z@ depth\z@ width\z@ }

\def\makestrut[#1;#2]{\vrule height#1 depth#2 width\z@ }

\def\drawoutlinebox[#1;#2;#3]{\T@stDimen=#3
        \vbox to#1{\hrule height\T@stDimen depth\z@
            \vss\hbox to#2{\vrule width\T@stDimen
                \hfil\makestrut[#1;\z@]%
                \vrule width\T@stDimen}\vss
            \hrule height\T@stDimen depth\z@}}



\@mparswitchfalse
\newcommand\mparnote[2]{\marginpar{\vskip-\baselineskip%
\raggedright\footnotesize \hrule\smallskip
\textbf{#1:}\;#2\par\smallskip\hrule}}

\newcommand{\Anote}[1]{\mparnote{ATTN}{#1}}
\newcommand{\Enote}[1]{\mparnote{Editor}{#1}}

%% Some standard "Anotes":
\newcommand\AnoteR[1][]{\Anote{Rephrased. #1}}
\newcommand\AnoteI[2][]{\Anote{``{#2}'' inserted. #1}}
\newcommand\AnoteC[3][]{\Anote{``{#2}'' changed to ``{#3}''. #1}}
\newcommand\AnoteD[2][]{\Anote{``{#2}'' deleted. #1}}
%% Query versions of these:
\newcommand\AnoteRQ{\Anote{Rephrased, ok?}}
\newcommand\AnoteIQ[1]{\Anote{``{#1}'' inserted, ok?}}
\newcommand\AnoteCQ[2]{\Anote{``{#1}'' changed to ``{#2}'', ok?}}
\newcommand\AnoteDQ[1]{\Anote{``{#1}'' deleted, ok?}}

\newcommand\AnoteRB{\Anote{Rephrased for line breaking.}}

\newcommand\AnoteNoAbsRef
    {\Anote{Citations cannot appear in an abstract, which should stand
    alone.}}
\newcommand\AnoteUnusedEqnos
    {\Anote{Equation numbers that are not referenced
        may have been removed.}}

\newcommand\AnoteUncitedRef [1]
    {\Anote{Works not cited in text will be removed
        from references: #1.}}

\newcommand\AnotePublicRef
[1]{\Anote{Works cited in the list of references
    should be publicly available.  Please furnish
    name of journal, publisher, or url,
    or else delete: #1}}

\newcommand\AnoteBeginMath
    {\Anote{A sentence should not begin with a
    formula. Words such as ``Then'', ``Also'', etc. may
    have been added to achieve this.  Check carefully.}}
\newcommand\AnoteNotitle{\Anote
    {Our class file does not support the ``numbered paragraph'' style,
    with numbered, but untitled sections.  Please add titles
    where requested.}
}
\newcommand\SuggestTitle[1]
{{??? ========== Suggest a title for this #1 ========== ???}}
\newcommand\AnoteColour{\Anote
{Although the online version supports colours, the printed version of
this journal is black and white. References to colours
    may not be meaningful.}
}



\def\newop#1{\@xp\DeclareMathOperator\csname#1\endcsname{#1}}

\def\emptyset{\varnothing}
\endinput
%%
%% End of file `cmsart.cls'.
